# StructEach()

call the given UDF/Closure with every entry (key/value) in the struct.

```
StructEach( struct=struct, closure=function, parallel=boolean, maxThreads=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | struct to take values from *Alias: structure* |  |
| closure | function | Yes | A closure function (UDF) with the following signature: `function(key, value, st){}` Which is called for each item in the struct. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

### Non-Member Function

```cfml
animals = {
	cow: "moo",
	pig: "oink",
	cat: "meow"
};

StructEach(animals, function(key) {
	// Show key 'arguments.key'
	Dump(
		label: "Key",
		var: arguments.key
	);

	// Show key's value 'animals[arguments.key]'
	Dump(
		label: arguments.key & "'s value",
		var: animals[arguments.key]
	);
});
```







# Categories

[Collections](../../categories/collection.md), [Structures](../../categories/struct.md), [Threads](../../categories/thread.md)

# See Also

[struct.each()](../objects/struct/each.md)