# StructDelete()

Removes an element from a structure.

Since Lucee 6, the member function `.delete()` now returns the modified struct

```
StructDelete( struct=struct, key=string, indicateNotExisting=boolean );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | Structure contains element to remove. *Alias: structure, object* |  |
| key | string | Yes | Element to remove |  |
| indicateNotExisting | boolean | No | * `true`: if the key existed in the struct, `StructDelete` will return `true`; if the key did not exist in the struct, `StructDelete` will return `false`. * `false` (default): irrespective of whether the key existed in the struct, `StructDelete` will return `true`. *Alias: indicateExists* |  |

# Examples

### Non-Member Function

```cfml
animals = {
	cow: "moo",
	pig: "oink",
	cat: "meow"
};

// Show current animals
Dump(
	label: "Current animals",
	var: animals
);

// Delete the key 'cat' from struct
StructDelete(animals, "cat");

// Show animals, cat has been deleted
Dump(
	label: "Animals with cat deleted",
	var: animals
);
```







# Categories

[Structures](../../categories/struct.md)

# See Also

[struct.delete()](../objects/struct/delete.md)