# StructCount()

Counts the keys in a structure.

```
StructCount( struct=struct );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | Structure to access *Alias: structure, object* |  |

# Examples

### Member Function

```cfml
animals = {
	cow: "moo",
	pig: "oink"
};

animalCount = animals.count();

echo("There are " & animalCount & " animal(s) in the 'animals' struct");
```

### Non-Member Function

```cfml
animals = {
	cow: "moo",
	pig: "oink"
};

animalCount = StructCount(animals);

echo("There are " & animalCount & " animal(s) in the 'animals' struct");
```







# Categories

[Structures](../../categories/struct.md)

# See Also

[Len()](len.md), [struct.len()](../objects/struct/len.md)