# StructCopy()

Copies a structure. Copies top-level keys, values, and arrays
in the structure by value; copies nested structures by
reference.

```
StructCopy( struct=struct );
```

**Returns:** object

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | Structure to copy *Alias: structure, object* |  |

# Examples

### Non-Member Function

```cfml
animals = {
	cow: "moo",
	pig: "oink"
};

// Show current animals
Dump(
	label: "Current animals",
	var: animals
);

// Copy animals struct to farm
farm = StructCopy(animals);

// Show farm, looks like animals
Dump(
	label: "Farm after StructCopy()",
	var: farm
);

// Add another animal. Will not affect farm.
StructAppend(animals, {
	cat: "meow"
});

// Show animals, now includes cat
Dump(
	label: "Animals with cat added",
	var: animals
);

// Show farm, does not have cat
Dump(
	label: "Farm copied from animals before cat was added",
	var: farm
);
```







# Categories

[Structures](../../categories/struct.md)

# See Also

[struct.copy()](../objects/struct/copy.md)