# StructClear()

Removes all data from a structure.

```
StructClear( struct=struct );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| struct | struct | Yes | Structure to clear *Alias: structure, object* |  |

# Examples

### Non-Member Function

```cfml
animals = {
	cow: "moo",
	pig: "oink"
};

// Show current animals
Dump(
	label: "Current animals",
	var: animals
);

// Clear struct
structClear(animals);

// Show animals, now empty
Dump(
	label: "Animals after calling StructClear()",
	var: animals
);
```







# Categories

[Structures](../../categories/struct.md)

# See Also

[struct.clear()](../objects/struct/clear.md)