# StructAppend()

Appends all the data from struct2 into struct1, replacing duplicate keys unless specified by the overwrite flag

```
StructAppend( Struct1=struct, Struct2=struct, OverwriteFlag=boolean );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| Struct1 | struct | Yes | Structure to which struct2 is appended. |  |
| Struct2 | struct | Yes | Structure that contains the data to append to struct1 |  |
| OverwriteFlag | boolean | No | - true (default): values in struct2 overwrite corresponding values in struct1. | true |

# Examples

### Non-Member Function

```cfml
animals = {
	cow: "moo",
	pig: "oink"
};

// Show current animals
Dump(
	label: "Current animals",
	var: animals
);

// Create a new animal
newAnimal = {
	cat: "meow"
};

// Append the newAnimal to animals
StructAppend(animals, newAnimal);

// Show animals, now includes cat
Dump(
	label: "Animals with cat added",
	var: animals
);
```







# Categories

[Structures](../../categories/struct.md)

# See Also

[struct.append()](../objects/struct/append.md)