# StringSome()

This function calls a given closure/function with every element in a given string and returns true, if one of the closure calls returns true.

**Introduced:** 6.0.0.126

```
StringSome( string=string, closure=function );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | Input string. *Alias: inputString, object* |  |
| closure | function | No | The value to find or a closure/function that gets every value of the array as input and returns true if the given value is right. *Alias: function, callback, udf* |  |

# Examples

```cfml
	myString="lucee";
	callback=(x)=>x >= 'a';
	writeDump(StringSome(myString, callback));

	callback_1=(x)=>x >= 'z';
	writeDump( StringSome(myString,callback_1));
```







# See Also

[string.some()](../objects/string/some.md)