# StringMap()

Iterates over every entry of the string and calls the closure function to work on the element of the string.

**Introduced:** 6.0.0.105

```
StringMap( string=string, closure=function );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | Input string. *Alias: inputString, object* |  |
| closure | function | No | Closure or a function reference that will be called for each of the iteration. *Alias: callback* |  |

# Examples

```cfml
   myString="Hello World";
      closure=function(val){
      return (val & 'a')
   }
   writeDump(StringMap(myString,closure));
```







# See Also

[string.map()](../objects/string/map.md)