# StringFilter()

Filters a string to its elements for which the callback function returns true.

**Introduced:** 6.0.0.105

```
StringFilter( string=string, closure=function );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | Input string. *Alias: string* |  |
| closure | function | Yes | Closure or a function reference that will be called for each of the iteration. *Alias: function, callback, udf* |  |

# Examples

```cfml
	letters = "abbcdB";
	callbackFunction = function(input){return input=="b";}

	result = stringFilter(letters,callbackFunction);
	writeDump(result);

	result1 = stringFilter("bob",callbackFunction);
	writeDump(result1);
```







# See Also

[string.filter()](../objects/string/filter.md)