# StringEvery()

Determines if all elements of a string satisfy a given condition.

**Introduced:** 6.0.0.105

```
StringEvery( string=string, closure=function );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | Input string. *Alias: inputString, object* |  |
| closure | function | Yes | Closure or a function reference that will be called for each of the iteration. *Alias: function, callback, udf* |  |

# Examples

```cfml
	letters = "I love lucee";
	callbackFunction = function(input){return input=="e";}

	result = stringEvery(letters, callbackFunction);
	writeDump(result);
	result1 = stringEvery("Eee", callbackFunction);
	writeDump(result1);
```







# See Also

[string.every()](../objects/string/every.md)