# StringEach()

Iterates over a string and runs the closure function for each element in the string.

**Introduced:** 6.0.0.105

```
StringEach( string=string, closure=function );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | Input string. *Alias: inputString, object* |  |
| closure | function | Yes | Closure or a function reference that will be called for each of the iteration. *Alias: function, callback, udf* |  |

# Examples

```cfml
	inputString = "abcd";
	stringEach(inputString,
		function(val) {
			writeoutput(val == "c");
		}
	);
```







# See Also

[string.each()](../objects/string/each.md)