# SSLCertificateInstall()

install certificates of a specific host

```
SSLCertificateInstall( host=string, port=number, cacertPath=any, password=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| host | string | Yes | host to get Certificates from |  |
| port | number | No | port of the host, default is 443 | 443 |
| cacertPath | any | No | Path to custom cacert file *Alias: path, cacert* |  |
| password | string | No | Password for cacert database |  |

# Usage Notes

Lucee 5 bundled a caerts file, which caused problems as it was never updated and root certs change, causing SSL errors for normal websites with valid certs.

Lucee 6 by default uses the JVM cacerts file, which currently doesn't work with this function [LDEV-917](https://luceeserver.atlassian.net/browse/LDEV-917)

To use the old behaviour, use `lucee.use.lucee.SSL.TrustStore=true` or `LUCEE_USE_LUCEE_SSL_TRUSTSTORE=true`

# Examples

```cfml
dump(SSLCertificateInstall("google.com"));
```







# Categories

[Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[SSLCertificateList()](sslcertificatelist.md), [<cfhttp>](../tags/http.md)