# Soundex()

Soundex is a phonetic algorithm for indexing names by sound, as pronounced in English.

The goal is for homophones to be encoded to the same representation so that they can be matched despite minor differences in spelling.

The algorithm mainly encodes consonants; a vowel will not be encoded unless it is the first letter.

Soundex is the most widely known of all phonetic algorithms, as it is a standard feature of MS SQL and Oracle, and is often used (incorrectly) as a synonym for "phonetic algorithm".

```
Soundex( str=string );
```

**Returns:** String

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| str | string | Yes | A string or a variable that contains one |  |

# Examples

```cfml
// Reduces names to a key or code based on their English pronunciation, such that similar sounding names share the same key; see also Metaphone()
name1 = soundex(str = "Smith");
name2 = soundex(str = "Smythe");
name3 = soundex(str = "Smithfield");
dump(name1); // S530
dump(name2); // S530
dump(name3); // S531
```







# Categories

[Strings](../../categories/string.md)

# See Also

[Metaphone()](metaphone.md)