# SizeOf()

This function is experimental, do not use in a production environment. This function returns the size in bytes of a given object.

```
SizeOf( obj=object, complex=boolean );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| obj | object | Yes | object to get size for |  |
| complex | boolean | No | if set to false, the size is returned, if set to true a struct containing the element count and the size is returned |  |

# Examples

```cfml
// Measuring size of application variables and dumping the content to screen
qSize = queryNew("key,size");
for (key in application) {
	qSize.addRow();
	qSize.setCell("key", key, qSize.recordCount);
	qSize.setCell("size", sizeOf(application[key]), qSize.recordCount);
}
qSize.sort("size", "desc");
dump(var=qSize, label="Size of all keys in application scope");
```







# Categories

[Debugging](../../categories/debugging.md)