# SetVariable()

Sets a variable value, supports scoped variable syntax

```
SetVariable( name=string, value=any );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| name | string | Yes | Name of the variable to set, allows using "." for structures/scopes. |  |
| value | any | Yes | the value to set |  |

# Examples

```cfml
	str="hi buddy";
	setVariable('str', "Value changed");
	writeOutput(str);

	setVariable('session.AAA', "Hello docs reader");
	dump(getVariable("session"));
```







# Categories

[Scopes](../../categories/scopes.md)

# See Also

[GetVariable()](getvariable.md)