# SetLocale()

Sets the country/language locale for CFML processing and the page returned to the client.

The locale value determines the default format of date, time, number, and currency values, according to language and regional conventions.

```
SetLocale( new_locale=locale );
```

**Returns:** locale

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| new_locale | locale | Yes | The name of a locale; for example, \"English (US)\" *Alias: locale* |  |

# Examples

```cfml
dump(getLocale());
setLocale("english (australian)");
dump(getLocale());
dump(Server.Coldfusion.SupportedLocales.listToArray().sort("text"));
```







# Categories

[Date and time](../../categories/datetime.md), [Internationalization](../../categories/internationalization.md)

# See Also

[GetLocale()](getlocale.md), [GetLocaleInfo()](getlocaleinfo.md)