# SetEncoding()

Sets the character encoding (character set) of Form and URL scope variable values.

Used when the character encoding of the input to a form, or the character encoding of a URL, is not in UTF-8 encoding.

```
SetEncoding( scope=string, encoding=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| scope | string | Yes | url, form |  |
| encoding | string | Yes | The character encoding in which text in the scope variables is encoded |  |

# Examples

```cfml
	my_data = SetEncoding("url", "euc-jp");
	my_scope = getEncoding("url");
	dump(my_scope); // UTF-8
```





