# SerializeJSON()

Converts CFML data into a JSON (JavaScript Object Notation) representation of the data.

```
SerializeJSON( var=any, queryFormat=any, useSecureJSONPrefixOrCharset=any, compact=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| var | any | Yes | A CFML data value or variable that represents one. *Alias: data* |  |
| queryFormat | any | No | Either a Boolean value that specifies whether to serialize CFML queries by Column, or one of the following formats as a String - 'struct' - 'row' - 'column' *Alias: serializeQueryByColumns* |  |
| useSecureJSONPrefixOrCharset | any | No | String characters that cannot be encoded by this charset get escaped, if not set the web charset is used. *Alias: charset, charsetName, useSecureJSONPrefix* |  |
| compact | boolean | No | If true, it does not use end-of-lines and indentation. Defaults to true. Also commonly called pretty printing | No |

# Examples

```cfml
  st = structNew();
  st.id = 1;
  st.Name = "Water";
  st.DESIGNATION = "Important source for all";
  st.data = [1,2,3,4,5];

  json= serializeJSON(st);
  writeDump(json);
  writeDump(deserializeJSON(json));
```

### Query Formats

```cfml
    q = queryNew(
        "id,name",
        "numeric,varchar",
        {
            id: [1,2,3],
            name: ['Neo','Trinity','Morpheus']
        }
    );
    dump(q);
    dump( var=deserializeJSON( serializeJSON(q) ),
        label="default" );
     dump( var=deserializeJSON( serializeJSON(q, true), false ),
        label="true" );     
    dump( var=deserializeJSON( serializeJSON(q, true) ),
        label='serializeQueryByColumns');
    dump( var=deserializeJSON( serializeJSON(q, 'struct') ),
        label="'struct'" );
    dump( var=deserializeJSON( serializeJSON(q, 'row') ),
        label="'row'" );
    dump( var=deserializeJSON( serializeJSON(q, 'column') ),
        label="'column'" );
```

### Pretty Printing

```cfml
<cfscript>
    obj = {
        name: "lucee",
        versions: [ 5,6,7 ]
    }
</cfscript>
<cfoutput>
<pre>
<b>Default behavior</b>
#serializeJson(var=obj,compact=true)#

<b>Pretty Print (compact=false)</b>
#serializeJson(var=obj,compact=false)#
</pre>
</cfoutput>

```

### Serializing a CFC's properties to JSON

```cfml
myCfc = new component {
  property name="foo" type="string";
  property name="bar" type="numeric";
  foo = "hello";
  bar = 42;
};
dump(myCfc); // See CFC object with properties
jsonString = serializeJson(var=myCfc, compact=false);
writeOutput(jsonString); // Output: {"foo":"hello","bar":42}
```







# Categories

[Strings](../../categories/string.md), [Formatting](../../categories/formatting.md), [JSON](../../categories/json.md), [JavaScript](../../categories/javascript.md)

# See Also

[Ajax features](../../categories/ajax.md), [DeserializeJSON()](deserializejson.md), [Serialize()](serialize.md), [ToScript()](toscript.md), [any.toJson()](../objects/any/tojson.md), [<cfwddx>](../tags/wddx.md)