# SerializeAISession()

Serializes an AI session to a JSON string that includes its configuration and conversation history. The serialized content includes:

- Configuration settings (temperature, limits, timeouts, system message)
- Complete conversation history with questions and answers

This function is useful for:

- Persisting AI sessions
- Debugging AI conversations
- Sharing or transferring AI session data
- Storing AI conversation history

Use `LoadAISession()` to restore a serialized session.

**Introduced:** 7.0.0.195

```
SerializeAISession( session=any, maxlength=numeric, condense=boolean );
```

**Returns:** String

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| session | any | Yes | The AI session object returned by LuceeCreateAISession(). This session maintains the conversation history and configuration settings like temperature and system message. *Alias: aiSession* |  |
| maxlength | numeric | No | Specifies the maximum number of conversation exchanges to retain in the serialized output. When specified, the function preserves the most recent exchanges up to this limit, truncating older exchanges while maintaining the session configuration. This helps control memory usage and storage requirements for long-running conversations without losing recent context. When used with condense=true, maxlength is applied before condensation. If not specified, all conversation history is retained. *Alias: length* |  |
| condense | boolean | No | Controls whether the conversation history should be condensed before serialization. When set to true, the function will intelligently summarize older parts of the conversation while preserving essential context. This reduces the overall token count and storage requirements while maintaining the important elements of the conversation history. Default is false, which preserves the complete conversation history. *Alias: summarize* |  |

# Examples

```cfml
// AI service name, e.g., 'test_ai'
aiSession = createAISession(name: 'test_ai', systemMessage: "Answer as Slim Shady.");
writeDump(serializeAISession(aiSession));
```







# Categories

[AI / LLM Integration](../../categories/ai.md)

# See Also

[LoadAISession()](loadaisession.md)