# Serialize()

Opposite of evaluate, this function serializes all cfml objects and all serializable Java objects. Can also serialize Components.

As objects can be serialized, this is not safe and cannot be trusted like JSON.

Avoid using serialize/evaluate with untrusted end user content, [SerializeJSON()](serializejson.md) / [DeserializeJSON()](deserializejson.md) is a safe alternative.

```
Serialize( object=any );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| object | any | Yes | An object to be serialized. |  |

# Examples

```cfml
struct_object = { name = "Joe", email = "joe@example.com" };
array_object = ["John Doe", { name = "Joe", email = "joe@example.com" }, 1000];
java_object = createObject("java", "java.lang.StringBuffer").init("");

dump(Serialize(struct_object)); // {'name':'Joe','email':'joe@example.com'}
dump(Serialize(array_object)); // ['John Doe',{'name':'Joe','email':'joe@example.com'},1000]
dump(Serialize(java_object));
```







# Categories

[Java](../../categories/java.md)

# See Also

[DeserializeJSON()](deserializejson.md), [Evaluate()](evaluate.md), [SerializeJSON()](serializejson.md), [UnserializeJava()](unserializejava.md), [Serialize all types of data by using serialize(data)](../../guides/Various/TIPS/TIPS-serilization.md)