# SecretProviderGet()

Returns a reference to a secret value stored in a configured Secret Provider. The function doesn't immediately return the actual value, but rather a value object that can be handled by Lucee like a simple value.

This reference is automatically resolved to its actual value when:

- It's converted to a real simple value (string, boolean, number, date)
- It's used in operations requiring a simple value

When used, the function automatically validates that the secret exists and throws an exception if not found.

**Introduced:** 7.0.0.197

```
SecretProviderGet( key=string, name=string );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| key | string | Yes | Key to read from the Secret Provider (e.g., "database.password", "api.key") |  |
| name | string | No | Name of the Secret Provider to read from, as configured in .CFConfig.json. If not defined, the function checks all configured providers in the order they are defined in .CFConfig.json until it finds the secret. |  |

# Examples

*There are currently no examples for this function*







# Categories

[Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[Secret Management](../../recipes/secret-provider.md)