# Sanitize()

Detects and masks sensitive information (such as passwords, API keys, tokens, etc.) from a given string. 
The function identifies patterns commonly used for sensitive data and replaces them with a mask.

```
Sanitize( text=string, replacement=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| text | string | Yes | The input string to be sanitized. *Alias: string* |  |
| replacement | string | No | The replacement string to use as a mask for sensitive data. If not specified, defaults to "****". *Alias: mask* | **** |

# Examples

```cfml
    input = "User login with password:secretPass123";
    //Default replacement
    writeDump(sanitize(input));
    //With the replacement mask
    writeDump(sanitize(input,"-----"));
```







# Categories

[Encode/Decode](../../categories/esapi.md)

# See Also

[string.second()](../objects/string/second.md)