# s3readBinary()

Reads an object from S3 as a binary.

**Requires Extension:** [S3 Resource Extension](https://download.lucee.org/#17AB52DE-B300-A94B-E058BD978511E39E)

```
s3readBinary( bucketName=string, objectName=string, accessKeyId=string, secretAccessKey=string, host=string, timeout=number );
```

**Returns:** binary

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| bucketName | string | Yes | Name of the bucket of your object to read *Alias: bucket* |  |
| objectName | string | Yes | Name of the object (path) within the bucket of your object to read *Alias: object, path* |  |
| accessKeyId | string | No | S3 accessKeyId, if not defined it checks the system property/environment variable for [lucee.s3.accesskeyid]. *Alias: accessKey, awsAccessKeyId, awsAccessKey* |  |
| secretAccessKey | string | No | S3 secretAccessKey, if not defined it checks the system property/environment variable for [lucee.s3.secretaccesskey]. *Alias: secretkey, awsSecretkey, awsSecretAccessKey* |  |
| host | string | No | the provider to connect, if not set Amazon AWS is used. *Alias: provider, server* |  |
| timeout | number | No | timeout for this execution | 10000 |

# Examples

*There are currently no examples for this function*







# Categories

[Binary data](../../categories/binary.md), [S3 ](../../categories/s3.md)

# See Also

[s3write()](s3write.md)