# s3move()

Moves an object in S3 from one bucket to an other.

**Requires Extension:** [S3 Resource Extension](https://download.lucee.org/#17AB52DE-B300-A94B-E058BD978511E39E)

```
s3move( srcBucketName=string, srcObjectName=string, trgBucketName=string, trgObjectName=string, acl=object, location=string, accessKeyId=string, secretAccessKey=string, host=string, timeout=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| srcBucketName | string | Yes | Name of the source bucket of your object to move. *Alias: srcBucket, sourceBucketName, sourceBucket* |  |
| srcObjectName | string | Yes | Name of the source object (path) within the bucket of your object to move. *Alias: sourceObjectName, srcObject, sourceObject* |  |
| trgBucketName | string | Yes | Name of the target bucket of your object to move *Alias: trgBucket, targetBucketName, targetBucket* |  |
| trgObjectName | string | No | Name of the target object (path)for the target bucket. If not defined the source object name is used. *Alias: targetObjectName, trgObject, targetObject* |  |
| acl | object | No | an array of struct where each struct represents an ACL grant *Alias: aclObject* |  |
| location | string | No | location of the S3 storage. *Alias: region* |  |
| accessKeyId | string | No | S3 accessKeyId, if not defined it checks the system property/environment variable for [lucee.s3.accesskeyid]. *Alias: accessKey, awsAccessKeyId, awsAccessKey* |  |
| secretAccessKey | string | No | S3 secretAccessKey, if not defined it checks the system property/environment variable for [lucee.s3.secretaccesskey]. *Alias: secretkey, awsSecretkey, awsSecretAccessKey* |  |
| host | string | No | the provider to connect, if not set Amazon AWS is used. *Alias: provider, server* |  |
| timeout | number | No | timeout for this execution | 10000 |

# Examples

*There are currently no examples for this function*







# Categories

[S3 ](../../categories/s3.md)