# s3listBucket()

List all objects in a s3 bucket

**Requires Extension:** [S3 Resource Extension](https://download.lucee.org/#17AB52DE-B300-A94B-E058BD978511E39E)

```
s3listBucket( bucketName=string, listener=any, blockfactor=numeric, accessKeyId=string, secretAccessKey=string, host=string, timeout=number );
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| bucketName | string | Yes | Name of the bucket to list objects from. *Alias: bucket* |  |
| listener | any | No | Optional. Defines the target where the downloaded data will be directed. If a file path is provided, the data is saved to that path, the file path must be provided with help of the function "fileOpen" like this [fileOpen(path,"write")]. If a closure or function is given, it will be invoked with parts of the downloaded data as its argument. The function should accept a single argument named 'line' for line-by-line processing, 'string{Number}' for string blocks of a specified size, or 'binary{Number}' for binary blocks of a specified size. The function should return a boolean value: returning false will stop further reading from S3, while true will continue the process. If this argument is omitted, the function returns the downloaded data directly. *Alias: closure, udf, function, component* |  |
| blockfactor | numeric | No | *Alias: maxKeys, blockSize* | 1000 |
| accessKeyId | string | No | S3 accessKeyId, if not defined it checks the system property/environment variable for [lucee.s3.accesskeyid]. *Alias: accessKey, awsAccessKeyId, awsAccessKey* |  |
| secretAccessKey | string | No | S3 secretAccessKey, if not defined it checks the system property/environment variable for [lucee.s3.secretaccesskey]. *Alias: secretkey, awsSecretkey, awsSecretAccessKey* |  |
| host | string | No | the provider to connect, if not set Amazon AWS is used. *Alias: provider, server* |  |
| timeout | number | No | timeout for this execution | 10000 |

# Examples

*There are currently no examples for this function*







# Categories

[S3 ](../../categories/s3.md)

# See Also

[s3clearBucket()](s3clearbucket.md)