# s3getversioninfo()

Returns version information as a query for a specific object or bucket.

**Requires Extension:** [S3 Resource Extension](https://download.lucee.org/#17AB52DE-B300-A94B-E058BD978511E39E)

```
s3getversioninfo( bucketName=string, objectName=string, accessKeyId=string, secretAccessKey=string, host=string, timeout=number );
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| bucketName | string | Yes | Name of the bucket to get info for. *Alias: bucket* |  |
| objectName | string | No | Name of the object (path) within the bucket to get info for. If not defined, info of the bucket is returned. *Alias: object, path* |  |
| accessKeyId | string | No | S3 accessKeyId. If not defined, checks the system property/environment variable for [lucee.s3.accesskeyid]. *Alias: accessKey, awsAccessKeyId, awsAccessKey* |  |
| secretAccessKey | string | No | S3 secretAccessKey. If not defined, checks the system property/environment variable for [lucee.s3.secretaccesskey]. *Alias: secretKey, awsSecretKey, awsSecretAccessKey* |  |
| host | string | No | The provider to connect to. If not set, Amazon AWS is used. *Alias: provider, server* |  |
| timeout | number | No | Timeout for this execution (in milliseconds). | 10000 |

# Examples

*There are currently no examples for this function*







# Categories

[S3 ](../../categories/s3.md)