# s3generateuri()

Generates a URI endpoint pointing to the object given

**Requires Extension:** [S3 Resource Extension](https://download.lucee.org/#17AB52DE-B300-A94B-E058BD978511E39E)

```
s3generateuri( bucketNameOrPath=string, objectName=string, type=string, secure=boolean, accessKeyId=string, secretAccessKey=string, host=string, timeout=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| bucketNameOrPath | string | Yes | This can be the bucketname or simple the virtual filesystem point for the file (if object name is no defined) *Alias: bucket, bucketName, path* |  |
| objectName | string | No | Name of the object (path) within the bucket of your object to read *Alias: object, path* |  |
| type | string | No | Defines the style/type created, possible values are: - virtualhost - path - arn - s3 For more details, please see: [Methods for accessing a bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-bucket-intro.html) [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) *Alias: style* | virtualhost |
| secure | boolean | No | Should a secure URL (https) be created or not. Only applies to type virtualhost and path. *Alias: secured* | true |
| accessKeyId | string | No | S3 accessKeyId, if not defined it checks the system property/environment variable for [lucee.s3.accesskeyid]. *Alias: accessKey, awsAccessKeyId, awsAccessKey* |  |
| secretAccessKey | string | No | S3 secretAccessKey, if not defined it checks the system property/environment variable for [lucee.s3.secretaccesskey]. *Alias: secretkey, awsSecretkey, awsSecretAccessKey* |  |
| host | string | No | the provider to connect, if not set Amazon AWS is used. *Alias: provider, server* |  |
| timeout | number | No | timeout for this execution | 10000 |

# Examples

*There are currently no examples for this function*





