# s3generatePresignedUrl()

Generates a presigned URL pointing to the object given

**Requires Extension:** [S3 Resource Extension](https://download.lucee.org/#17AB52DE-B300-A94B-E058BD978511E39E)

```
s3generatePresignedUrl( bucketNameOrPath=string, objectName=string, expireDate=datetime, httpMethod=string, sseAlgorithm=string, sseCustomerKey=string, checksum=string, type=string, disposition=string, encoding=string, version=string, zeroByte=boolean, responseHeaders=struct, accessKeyId=string, secretAccessKey=string, host=string, timeout=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| bucketNameOrPath | string | Yes | This can be the bucketname or simple the virtual filesystem point for the file (if object name is no defined) *Alias: bucket, bucketName, path* |  |
| objectName | string | No | Name of the object (path) within the bucket of your object to read *Alias: object, path* |  |
| expireDate | datetime | No | Date time when the URL should expire. *Alias: expire* |  |
| httpMethod | string | No | The desired HTTP method (e.g., GET, PUT). Defaults to GET. *Alias: method* |  |
| sseAlgorithm | string | No | The desired server-side encryption algorithm, valid values are AES256 or KMS. *Alias: algorithm* |  |
| sseCustomerKey | string | No | The server-side encryption customer-provided key. *Alias: customerKey* |  |
| checksum | string | No | The base64 encoded MD5 checksum of the object's content. *Alias: contentMd5* |  |
| type | string | No | The MIME type of the object (e.g., "text/plain"). *Alias: contentType* |  |
| disposition | string | No | Specifies presentational information for the object, like "attachment; filename=\"filename.pdf\"". *Alias: contentDisposition* |  |
| encoding | string | No | Specifies content encodings applied to the object, like gzip. *Alias: contentEncoding* |  |
| version | string | No | The version ID of the object if versioning is enabled. *Alias: versionId* |  |
| zeroByte | boolean | No | A flag to specify if the object has zero-byte content. *Alias: zeroByteContent* |  |
| responseHeaders | struct | No | Struct of custom response headers for custom metadata prefixed with "x-amz-meta-" (prefix is optional, function will add it if missed). *Alias: customResponseHeaders* |  |
| accessKeyId | string | No | S3 accessKeyId, if not defined it checks the system property/environment variable for [lucee.s3.accesskeyid]. *Alias: accessKey, awsAccessKeyId, awsAccessKey* |  |
| secretAccessKey | string | No | S3 secretAccessKey, if not defined it checks the system property/environment variable for [lucee.s3.secretaccesskey]. *Alias: secretkey, awsSecretkey, awsSecretAccessKey* |  |
| host | string | No | the provider to connect, if not set Amazon AWS is used. *Alias: provider, server* |  |
| timeout | number | No | timeout for this execution | 10000 |

# Examples

*There are currently no examples for this function*







# Categories

[S3 ](../../categories/s3.md)