# s3exists()

Checks if given object exists in

**Requires Extension:** [S3 Resource Extension](https://download.lucee.org/#17AB52DE-B300-A94B-E058BD978511E39E)

```
s3exists( bucketName=string, objectName=string, accessKeyId=string, secretAccessKey=string, host=string, timeout=number );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| bucketName | string | Yes | Name of the bucket of your object to check *Alias: bucket* |  |
| objectName | string | No | Name of the object (path) within the bucket of your object to check *Alias: object, path* |  |
| accessKeyId | string | No | S3 accessKeyId, if not defined it checks the system property/environment variable for [lucee.s3.accesskeyid]. *Alias: accessKey, awsAccessKeyId, awsAccessKey* |  |
| secretAccessKey | string | No | S3 secretAccessKey, if not defined it checks the system property/environment variable for [lucee.s3.secretaccesskey]. *Alias: secretkey, awsSecretkey, awsSecretAccessKey* |  |
| host | string | No | the provider to connect, if not set Amazon AWS is used. *Alias: provider, server* |  |
| timeout | number | No | timeout for this execution | 10000 |

# Examples

*There are currently no examples for this function*







# Categories

[S3 ](../../categories/s3.md)