# s3delete()

deletes a bucket or an object within a bucket.

**Requires Extension:** [S3 Resource Extension](https://download.lucee.org/#17AB52DE-B300-A94B-E058BD978511E39E)

```
s3delete( bucketName=string, objectName=string, force=boolean, accessKeyId=string, secretAccessKey=string, host=string, timeout=number );
```

**Returns:** query

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| bucketName | string | Yes | Name of the bucket to delete. *Alias: bucket* |  |
| objectName | string | No | Name of the object to delete, if not defined the bucket itself is deleted. *Alias: object* |  |
| force | boolean | No | Also delete bucket if it has content. |  |
| accessKeyId | string | No | S3 accessKeyId, if not defined it checks the system property/environment variable for [lucee.s3.accesskeyid]. *Alias: accessKey, awsAccessKeyId, awsAccessKey* |  |
| secretAccessKey | string | No | S3 secretAccessKey, if not defined it checks the system property/environment variable for [lucee.s3.secretaccesskey]. *Alias: secretkey, awsSecretkey, awsSecretAccessKey* |  |
| host | string | No | the provider to connect, if not set Amazon AWS is used. *Alias: provider, server* |  |
| timeout | number | No | timeout for this execution | 10000 |

# Examples

*There are currently no examples for this function*







# See Also

[s3deletebucket()](s3deletebucket.md)