# s3clearBucket()

Removes all objects from a s3 bucket, unless maxage is set, in that case only objects that are older than maxage are removed.

**Requires Extension:** [S3 Resource Extension](https://download.lucee.org/#17AB52DE-B300-A94B-E058BD978511E39E)

```
s3clearBucket( bucketName=string, maxage=timespan, accessKeyId=string, secretAccessKey=string, host=string, timeout=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| bucketName | string | Yes | Name of the bucket to list objects from. *Alias: bucket* |  |
| maxage | timespan | No | Max age of the object we keep, if not set all objects are removed. *Alias: age* |  |
| accessKeyId | string | No | S3 accessKeyId, if not defined it checks the system property/environment variable for [lucee.s3.accesskeyid]. *Alias: accessKey, awsAccessKeyId, awsAccessKey* |  |
| secretAccessKey | string | No | S3 secretAccessKey, if not defined it checks the system property/environment variable for [lucee.s3.secretaccesskey]. *Alias: secretkey, awsSecretkey, awsSecretAccessKey* |  |
| host | string | No | the provider to connect, if not set Amazon AWS is used. *Alias: provider, server* |  |
| timeout | number | No | timeout for this execution | 10000 |

# Examples

*There are currently no examples for this function*







# Categories

[S3 ](../../categories/s3.md)

# See Also

[s3listBucket()](s3listbucket.md)