# s3addacl()

Adds ACL to existing ACL for object or bucket. You can provide the endpoint as a bucket/object definition (S3AddACL(bucket:"mybucket",object:"myobject.txt",acl:data) ) or as a virtual filesystem path (S3AddACL(path:"s3://mybucket/myobject.txt",acl:data) ).

**Requires Extension:** [S3 Resource Extension](https://download.lucee.org/#17AB52DE-B300-A94B-E058BD978511E39E)

```
s3addacl( bucketNameOrPath=string, objectName=string, aclObject=object, accessKeyId=string, secretAccessKey=string, host=string, timeout=number );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| bucketNameOrPath | string | Yes | This can be the bucketname or a virtual filesystem path for a file/directory (example "s3://mybucket/myobject.txt"). *Alias: bucket, bucketName, path* |  |
| objectName | string | No | Name of the object (path) within the bucket of your object to read. In case you have defined a bucket with the first argument. *Alias: object, path* |  |
| aclObject | object | Yes | an array of struct where each struct represents an ACL grant *Alias: acl* |  |
| accessKeyId | string | No | S3 accessKeyId, if not defined it checks the system property/environment variable for [lucee.s3.accesskeyid]. *Alias: accessKey, awsAccessKeyId, awsAccessKey* |  |
| secretAccessKey | string | No | S3 secretAccessKey, if not defined it checks the system property/environment variable for [lucee.s3.secretaccesskey]. *Alias: secretkey, awsSecretkey, awsSecretAccessKey* |  |
| host | string | No | the provider to connect, if not set Amazon AWS is used. *Alias: provider, server* |  |
| timeout | number | No | timeout for this execution | 10000 |

# Examples

*There are currently no examples for this function*





