# RunAsync()

A function that returns a Future object, which is an eventual result of an asynchronous operation (like a promise in JavaScript)

The Future Object has the following functions:

- cancel() returns Boolean
- isCancelled() returns Boolean
- isDone() returns Boolean
- error() returns Future
- get(closure, timezone) returns Future
- then(closure, timezone) returns Future

```
RunAsync( closure=object, timeout=number );
```

**Returns:** object

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | object | Yes | Closure function that returns a Future object, which holds the result. *Alias: callback, udf, function* |  |
| timeout | number | No | timeout for the action | 0 |

# Examples

```cfml
	future = runAsync(function(){
		return 10;
	}).then( function(input){
		return input + 20;
	});
	dump(future);
	result = future.get(10); // 10 is timeout(in ms)
	writeOutput(result); // output is 30
```







# Categories

[Threads](../../categories/thread.md)