# Round()

Rounds a number to the closest integer. If rounding to a specific number of decimals is needed, use the *precision* attribute to define the number of decimals to be rounded to.

```
Round( number=number, precision=number );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| number | number | Yes | Number to round |  |
| precision | number | No | Number of decimal points to round to | 0 |

# Examples

```cfml
	var pi = 3.1415926535;
	var pi_rounded = Round(pi, 2);

	echo(pi); // 3.1415926535
	echo('<br>');
	echo(pi_rounded); // 3.14
```







# Categories

[Numbers](../../categories/number.md)

# See Also

[numeric.round()](../objects/numeric/round.md)