# RJustify()

Right justifies characters of a string.

```
RJustify( string=string, length=number );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | A string enclosed in quotation marks |  |
| length | number | Yes | Length of field in which to justify string |  |

# Examples

```cfml
	writeDump(
		label:"",
		var:RJustify("",4));
	writeDump(
		label:"",
		var:RJustify("abc",1));
	writeDump(
		label:"",
		var:RJustify("abc",5));


    writeoutput("<hr>");
    s = "";
    res = rJustify(s, 4);
    writeDump(len(res)); // length is 4
    writeoutput("<pre>|#res#|</pre><hr>");

    s = "abc";
    res = rJustify(s, 10);
    writeDump(len(res)); // length is 10
    writeoutput("<pre>|#res#|</pre><hr>");

    s = "10";
    res = rJustify(s, 8);
    writeDump(len(res)); // length is 8
    writeoutput("<pre>|#res#|</pre>");

```







# Categories

[Strings](../../categories/string.md), [Formatting](../../categories/formatting.md)

# See Also

[LJustify()](ljustify.md), [string.rJustify()](../objects/string/rjustify.md)