# RestSetResponse()

Sets the custom responses.

```
RestSetResponse( response=struct );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| response | struct | Yes | A struct that contains the response details. *Alias: rsp* |  |

# Examples

```cfml
RestSetResponse(
    {
        "status":"200",
        "content":"[]",
        "headers":{"Content-Type": "application/javascript"}
    }
);

RestSetResponse(
    {
        "status":"201",
        "headers":{
          "Location": "/rest/api/thisResource/001",
          "Content-Location": "/rest/api/thisResource/001"
        }
    }
);

RestSetResponse(
    {
        "status":"404",
        "content":"This resource does not exist"
    }
);
```







# Categories

[REST](../../categories/rest.md)

# See Also

[RestDeleteApplication()](restdeleteapplication.md), [RestInitApplication()](restinitapplication.md), [REST Services with Lucee](../../recipes/rest-services.md)