# RestInitApplication()

Registers the directory path under the service mapping virtual directory.

If no service mapping is provided, the application name is used.

If the rest application is already registered, it is refreshed.

```
RestInitApplication( dirPath=string, serviceMapping=string, default=boolean, password=string );
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| dirPath | string | Yes | Path to the directory to be registered or reset. This folder should contain - one or more REST enabled CFCs, i.e. with `rest=true` - An `Application.cfc` (if required) *Alias: dir, directory, path* |  |
| serviceMapping | string | No | Alternate string to be used for application name while calling the REST service. *Alias: mapping* |  |
| default | boolean | No | set if the mapping is a default mapping or not |  |
| password | string | No | password for the web administrator, this is needed when you update/create a REST mapping. *Alias: webAdminPassword* |  |

# Usage Notes

Despite the name, this is a server level configuration

# Examples

```cfml
restInitApplication( dirPath="path_to_cfc_dir", serviceMapping="api", password="webAdminPassword" );
```

### Simple REST enabled CFC example

```cfml
component restpath="/restExample" rest="true" {

	remote function getApplicationName() restpath="getApplicationName" httpmethod="GET,HEAD" {
		return "applicationName:" & getApplicationSettings().name;
	}

}
```







# Categories

[Application](../../categories/application.md), [REST](../../categories/rest.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[RestDeleteApplication()](restdeleteapplication.md), [RestSetResponse()](restsetresponse.md), [REST Services with Lucee](../../recipes/rest-services.md), [<cfcomponent>](../tags/component.md), [<cffunction>](../tags/function.md)