# REReplaceNoCase()

Uses a regular expression to search a string for a string pattern and replace it with another.

The search is case-insensitive.

```
REReplaceNoCase( string=string, regex=string, substring=string, scope=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | A string or a variable that contains one. |  |
| regex | string | Yes | Regular expression to replace. *Alias: reg_expression* |  |
| substring | string | Yes | replacement |  |
| scope | string | No | - one (default): Replace the first occurrence of the regular expression. - all: Replace all occurrences of the regular expression. | one |

# Examples

```cfml
writeDump(REReplaceNoCase("xxabcxxabcxx","ABC","def"));
writeDump(REReplaceNoCase("CABARET","C|B","G","ALL"));
writeDump(REReplaceNoCase("cabaret","[A-Z]","G","ALL"));
writeDump(REReplaceNoCase("I love jeLLies","jell(y|ies)","cookies"));
writeDump(REReplaceNoCase("I love Jelly","jell(y|ies)","cookies"));
```







# Categories

[Strings](../../categories/string.md), [Regex](../../categories/regex.md)

# See Also

[string.rEReplaceNoCase()](../objects/string/rereplacenocase.md)