# REReplace()

Uses a regular expression (RE) to search a string for a string pattern and replace it with another.

The search is case-sensitive.

```
REReplace( string=string, regex=string, substring=string, scope=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | String within which to search. |  |
| regex | string | Yes | Regular expression to replace. *Alias: reg_expression* |  |
| substring | string | Yes | replacement |  |
| scope | string | No | - one (default): Replace the first occurrence of the regular expression. - all: Replace all occurrences of the regular expression. | one |

# Examples

```cfml
	writeDump(rereplace("xxabcxxabcxx","ABC","def"));
	writeDump(REReplace("CABARET","C|B","G","ALL"));
	writeDump(REReplace("CABARET","[A-Z]","G","ALL"));
	writeDump(REReplace("I love jellies","jell(y|ies)","cookies"));
	writeDump(REReplace("I love jelly","jell(y|ies)","cookies"));
	writeDump(REReplace("hello john how are you:", "['[:space:]']+", "_", "ALL"));
```







# Categories

[Strings](../../categories/string.md), [Regex](../../categories/regex.md)

# See Also

[string.rEReplace()](../objects/string/rereplace.md)