# ReplaceNoCase()

Replaces occurrences of `substring1` with `substring2`, in the specified scope. 

The search is case-insensitive.

```
ReplaceNoCase( string=string, substring=any, replacement=string, scope=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | A string (or variable that contains one) within which to replace substring. |  |
| substring | any | Yes | Substring for which to search. Optionally pass a Struct with key/value pairs to do a replace all *Alias: substring1* |  |
| replacement | string | No | Substring with which to replace the found matches. This arg is required if the substring1 arg is a string *Alias: substring2* |  |
| scope | string | No | scope for the execution: - one (default): Replace the first occurrence - all: Replace all occurrences | one |

# Examples

```cfml
writeDump(replaceNoCase("xxabcxxabcxx","ABC","def"));
writeDump(replaceNoCase("xxabcxxabcxx","abc","def","All"));
writeDump(replaceNoCase("xxabcxxabcxx","AbC","def","hans"));
writeDump(replaceNoCase("a.b.c.d",".","-","all"));
test = "camelcase CaMeLcAsE CAMELCASE";
test2 = replaceNoCase(test, "camelcase", "CamelCase", "all");
writeDump(test2);

writeDump(var=
    replaceNoCase("One string, two strings, Three strings",
    	{"one": 1, "Two": 2, "three": 3, "string": "txt", "text": "string"}),
	label="replaceNoCase via a struct"
); // struct keys need to be quoted
```







# Categories

[Strings](../../categories/string.md)

# See Also

[Replace()](replace.md), [string.replaceNoCase()](../objects/string/replacenocase.md)