# ReplaceListNoCase()

Replaces occurrences of the elements from a delimited list in a string with corresponding elements from another delimited list.

The search is NOT case-sensitive.

```
ReplaceListNoCase( string=string, list1=string, list2=string, delimiter_list1=string, delimiter_list2=string, includeEmptyFields=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | A string |  |
| list1 | string | Yes | string list of search strings |  |
| list2 | string | Yes | string list of replacement strings |  |
| delimiter_list1 | string | No | Delimiter for search, or if no replacement delimiter is defined, this delimiter is used for search and replacement. *Alias: delimiter, delimiterList1* |  |
| delimiter_list2 | string | No | Delimiter for replacement. *Alias: delimiterList2* |  |
| includeEmptyFields | boolean | No | When true, empty elements are preserved |  |

# Examples

```cfml

writeDump(replaceListNoCase("Hi USER!, Have a nice day.",'hi,user','Welcome,buddy'));//Welcome buddy!, Have a nice day.

//Member function
str="xxxAbCdefghijxxXabcDefghij";
writeDump(str.replaceListNoCase('a,b,c,d,e,f,g,h,i,j', '0,1,2,3,4,5,6,7,8,9'));

```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[ReplaceList()](replacelist.md), [string.replaceListNoCase()](../objects/string/replacelistnocase.md)