# ReplaceList()

Replaces occurrences of the elements from a delimited list, in a string with corresponding elements from another delimited list. 

The search is case-sensitive.

```
ReplaceList( string=string, list1=string, list2=string, delimiter_list1=string, delimiter_list2=string, includeEmptyFields=boolean );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | A string |  |
| list1 | string | Yes | string list of search strings |  |
| list2 | string | Yes | string list of replacement strings |  |
| delimiter_list1 | string | No | Delimiter for search, or if no replacement delimiter is defined, this delimiter is used for search and replacement. *Alias: delimiter, delimiterList1* |  |
| delimiter_list2 | string | No | Delimiter for replacement. *Alias: delimiterList2* |  |
| includeEmptyFields | boolean | No | When true, empty elements are preserved |  |

# Examples

```cfml
writeDump(ReplaceList('xxxabcdxxxabcd','a,b,c,d','0,1,2,3'));
writeDump(ReplaceList('xxxabcdxxxabcd','a,b,c,d','11'));
writeDump(ReplaceList('xxxabcdxxxabcd','a','1,2,3'));
writeDump(ReplaceList('xxxabcdxxxabcd','',''));
```







# Categories

[Lists](../../categories/list.md), [Strings](../../categories/string.md)

# See Also

[ReplaceListNoCase()](replacelistnocase.md), [string.replaceList()](../objects/string/replacelist.md)