# Replace()

Replaces occurrences of `substring1` in a string with `substring2`, in a specified scope.

The search is case-sensitive.

```
Replace( string=string, substring=any, replacement=any, scope=string );
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | String in which to search. |  |
| substring | any | Yes | Substring for which to search. Optionally pass a Struct with key/value pairs to do a replace all *Alias: sub1, find, substring1* |  |
| replacement | any | No | Substring with which to replace the found matches. This arg is required if the substring1 arg is a string You can also pass in a function with the signature `function(find,index,input)` *Alias: sub2, repl, substring2* |  |
| scope | string | No | scope for the execution: - one (default): replaces only the first occurrence - all: replaces all occurrences | one |

# Examples

```cfml

writeDump(replace("xxabcxxabcxx","abc","def"));
writeDump(replace("xxabcxxabcxx","abc","def","All"));
writeDump(replace("abc","a","b","all"));
writeDump(replace("a.b.c.d",".","-","all"));
test = "camelcase CaMeLcAsE CAMELCASE";
test2 = Replace(test, "camelcase", "CamelCase", "all");
writeDump(test2);
replacer = function(find,index,input){
	dump(var=arguments, label="replacement arguments");
	return "-#index#-";
};
writeDump(var=
    replace("one string, two strings, three strings", "string",
    	replacer,
        "all"
    ),
	label="replace with a function"
);

writeDump(var=
    replace("one string, two strings, three strings",
    	{"one": 1, "two": 2, "three": 3, "string": "txt", "text": "string"}),
	label="replace via a struct"
); // struct keys need to be quoted

```







# Categories

[Strings](../../categories/string.md)

# See Also

[ReplaceNoCase()](replacenocase.md), [string.replace()](../objects/string/replace.md)