# REMatchNoCase()

Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.

```
REMatchNoCase( reg_expression=string, string=string, multiline=boolean );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| reg_expression | string | Yes | Regular expression for which to search. Case-insensitive. *Alias: regex* |  |
| string | string | Yes | String in which to search. |  |
| multiline | boolean | No | If true indicate the regular expression should treat input as having multiple lines. This option affects the interpretation of the ^ and $ metacharacters. When true the ^ metacharacter matches at the beginning of every line, and the $ metacharacter matches at the end of every line. Additionally the . metacharacter will not match newlines when true. | false |

# Examples

```cfml

writeDump(REMatchNoCase('[A-Z]+','12AbcacAcdd'));

```







# Categories

[Strings](../../categories/string.md), [Regex](../../categories/regex.md)

# See Also

[string.REMatchNoCase()](../objects/string/rematchnocase.md)