# REMatch()

Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.

```
REMatch( regex=string, string=string, multiline=boolean );
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| regex | string | Yes | Regular expression for which to search. Case sensitive. *Alias: reg_expression* |  |
| string | string | Yes | String in which to search. |  |
| multiline | boolean | No | If true indicate the regular expression should treat input as having multiple lines. This option affects the interpretation of the ^ and $ metacharacters. When true the ^ metacharacter matches at the beginning of every line, and the $ metacharacter matches at the end of every line. Additionally the . metacharacter will not match newlines when true. | false |

# Examples

```cfml

writeDump(REMatch('[a-z]+','AbcacAcdd'));

```







# Categories

[Strings](../../categories/string.md), [Regex](../../categories/regex.md)

# See Also

[string.REMatch()](../objects/string/rematch.md)