# REFindNoCase()

Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.

The search is case-insensitive.

```
REFindNoCase( reg_expression=string, string=string, start=number, returnSubExpressions=boolean, scope=string, multiline=boolean );
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| reg_expression | string | Yes | Regular expression for which to search. Case-insensitive. |  |
| string | string | Yes | String in which to search. |  |
| start | number | No | A positive integer. Position in the string at which to start search. The default value is 1. | 1 |
| returnSubExpressions | boolean | No | - True: if the regular expression is found, the first array element contains the length and position, respectively, of the first match. If the regular expression contains parentheses that group subexpressions, each subsequent array element contains the length and position, respectively, of the first occurrence of each group. If the regular expression is not found, the arrays each contain one element with the value 0. - False: (Default) the function returns the position in the string where the match begins. Default. |  |
| scope | string | No | One: (Default)Returns the first value that matches the regex All: Returns all values that match the regex |  |
| multiline | boolean | No | If true indicate the regular expression should treat input as having multiple lines. This option affects the interpretation of the ^ and $ metacharacters. When true the ^ metacharacter matches at the beginning of every line, and the $ metacharacter matches at the end of every line. Additionally the . metacharacter will not match newlines when true. | false |

# Examples

```cfml
	writeDump(REFindNoCase("a+c+", "abcaaCCdd"));
	writeDump(REFindNoCase("a+c*", "AbcaAcCdd"));
	writeDump(REFindNoCase("[\?&]rep = ", "report.cfm?rep = 1234&u = 5"));
	writeDump(REFindNoCase("a+", "baaaA"));
	writeDump(REFindNoCase(".*", ""));

	teststring1 = "The cat in the hat hat came back!";
	st1 = REFind("(['[:alpha:]']+)[ ]+(\1)",teststring1,1,"TRUE");
	writeDump(st1['len'][3]);

	teststring2 = "AAAXAAAA";
	st2 = REFind("x",teststring2,1,"TRUE");
	writeDump(arrayLen(st2['pos']));
```







# Categories

[Strings](../../categories/string.md), [Regex](../../categories/regex.md)

# See Also

[string.reFindNoCase()](../objects/string/refindnocase.md)