# RandRange()

Generates a random integer between two specified numbers.

Requests for random integers that are greater than 100,000,000 result in non-random numbers, to prevent overflow during internal computations.

```
RandRange( number1=number, number2=number, algorithm=string );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| number1 | number | Yes | smaller number |  |
| number2 | number | Yes | bigger number |  |
| algorithm | string | No | The algorithm to use to generate the random number. - CFMX_COMPAT (very simple and not very secure algorithm (default)). - SHA1PRNG (generates a number using the Sun Java SHA1PRNG algorithm. This algorithm provides greater randomness than the default algorithm) - IBMSecureRandom (IBM JVM does not support the SHA1PRNG algorithm) |  |

# Examples

```cfml

writeDump(randRange(25,125,'CFMX_COMPAT'));
writeDump(randRange(100,500,'SHA1PRNG'));

```







# Categories

[Cryptography](../../categories/crypto.md), [Math](../../categories/math.md), [Numbers](../../categories/number.md)

# See Also

[Randomize()](randomize.md)