# Randomize()

Seeds the pseudo-random number generator with an
integer number, ensuring repeatable number patterns.

```
Randomize( number=number, algorithm=string );
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| number | number | Yes | a number |  |
| algorithm | string | No | The algorithm to use to generated the random number. |  |

# Examples

```cfml
writeDump(Randomize(8,'SHA1PRNG'));
writeDump(Randomize(10) GTE 0 and Randomize(10) LTE 1);
randomize(55);
loop index="i" from="1" to="3"{
	writeDump(rand());
}
```







# Categories

[Cryptography](../../categories/crypto.md), [Numbers](../../categories/number.md)

# See Also

[Rand()](rand.md), [RandRange()](randrange.md)