# QuerySort()

Sorts the query based on the column specified and the order criteria given. Modifies the original query object

```
QuerySort( query=query, columnNameOrSortFunc=any, direction=string );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query | query | Yes | the query to sort |  |
| columnNameOrSortFunc | any | Yes | - a list of names - a single column name - or a function used as comparator with the following constructor `function(struct row1, struct row2){ return true / false;}`. *Alias: column_name, columnNames, columnName, name, names, column_names, sort, function, udf, sortFunction, sortFunc* |  |
| direction | string | No | A list of directions or a single direction definition (asc, desc), The list must have the same length as the columnName list. Only used when the second argument defines a list of column names. *Alias: directions, dir* |  |

# Examples

```cfml
people = QueryNew( "name,dob,age", "varchar,date,int", [
    [ "Susi", CreateDate( 1970, 1, 1 ), 70 ],
    [ "Urs" , CreateDate( 1995, 1, 1 ), 40 ],
    [ "Fred", CreateDate( 1960, 1, 1 ), 50 ],
    [ "Jim" , CreateDate( 1988, 1, 1 ), 30 ]
]);

Dump( var=people, label="people - original query" );

QuerySort(people, 'name', 'asc');
dump(var=people, label='people - sorted by name');

QuerySort(people, function(row1, row2){
	return compare(arguments.row1.age, arguments.row2.age);
});
dump(var=people, label='people - sorted by age');

```







# Categories

[Queries](../../categories/query.md), [Sorting](../../categories/sort.md)

# See Also

[query.sort()](../objects/query/sort.md)