# QuerySome()

This function calls a given closure/function with every element in a given query and returns true, if one of the closure calls returns true.

```
QuerySome( query=query, closure=function, parallel=boolean, maxThreads=number );
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| query | query | Yes | query to iterate *Alias: object* |  |
| closure | function | Yes | function/closure that implements the following constructor `function(struct row [, number rowNumber, query query]):boolean`. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* | 20 |

# Examples

```cfml
	people = QueryNew( "name,dob,age", "varchar,date,int", [
		[ "Susi", CreateDate( 1970, 1, 1 ), 0 ],
		[ "Urs" , CreateDate( 1995, 1, 1 ), 0 ],
		[ "Fred", CreateDate( 1960, 1, 1 ), 0 ],
		[ "Jim" , CreateDate( 1988, 1, 1 ), 0 ]
	]);
	valid = querySome(people,function(row, rowNumber, qryData){
	    return ((DateDiff('yyyy', row.dob, Now()) > 0) && (DateDiff('yyyy', row.dob, Now()) <= 100))
	});
	writeDump(valid);
```







# Categories

[Queries](../../categories/query.md), [Collections](../../categories/collection.md)

# See Also

[query.some()](../objects/query/some.md)